import java.awt.*;
import java.awt.image.*;
import java.io.File;
import javax.swing.*;
import java.util.ArrayList;

class MapPanel extends JPanel {

        public static ImageIcon makeIcon (String filename) {
            return new ImageIcon ("Icons" + File.separator + filename);
        }

        public static final ImageIcon
                WallIcon         = makeIcon("wall.gif"),
                DoorIcon         = makeIcon("door.gif"),
                FakeWallIcon     = makeIcon("fakewall.gif"),
                AltarIcon        = makeIcon("altar.gif"),
                AlcoveIcon       = makeIcon("alcove.gif"),
                FountainIcon     = makeIcon("fountain.gif"),
                StairsDownIcon   = makeIcon("stairsdown.gif"),
                StairsUpIcon     = makeIcon("stairsup.gif"),
                TeleportIcon     = makeIcon("teleport.gif"),
                PitIcon          = makeIcon("pit.gif"),
                MirrorIcon       = makeIcon("mirror.gif"),
                WritingIcon      = makeIcon("writing.gif"),
                LauncherIcon     = makeIcon("launcher.gif"),
                GeneratorIcon    = makeIcon("generator.gif"),
                WallSwitchIcon   = makeIcon("wallswitch.gif"),
                MultWallSwitchIcon = makeIcon("multwallswitch.gif"),
                FloorSwitchIcon  = makeIcon("floorswitch.gif"),
                MultFloorSwitchIcon = makeIcon("multfloorswitch.gif"),
                SconceIcon       = makeIcon("sconce.gif"),
                DecorationIcon   = makeIcon("decoration.gif"),
                FDecorationIcon  = makeIcon("fdecoration.gif"),
                PillarIcon       = makeIcon("pillar.gif"),
                InvisibleWallIcon = makeIcon("invisiblewall.gif"),
                EventIcon        = makeIcon("event.gif"),
                GameWinIcon      = makeIcon("gamewin.gif"),
                StormIcon        = makeIcon("stormbringer.gif"),
                GemIcon          = makeIcon("powergem.gif"),
                FulYaIcon        = makeIcon("fulya.gif"),

                WallIconS        = makeIcon("wall-s.gif"),
                DoorIconS        = makeIcon("door-s.gif"),
                FakeWallIconS    = makeIcon("fakewall-s.gif"),
                AltarIconS       = makeIcon("altar-s.gif"),
                AlcoveIconS      = makeIcon("alcove-s.gif"),
                FountainIconS    = makeIcon("fountain-s.gif"),
                StairsDownIconS  = makeIcon("stairsdown-s.gif"),
                StairsUpIconS    = makeIcon("stairsup-s.gif"),
                TeleportIconS    = makeIcon("teleport-s.gif"),
                PitIconS         = makeIcon("pit-s.gif"),
                MirrorIconS      = makeIcon("mirror-s.gif"),
                WritingIconS     = makeIcon("writing-s.gif"),
                LauncherIconS    = makeIcon("launcher-s.gif"),
                GeneratorIconS   = makeIcon("generator-s.gif"),
                WallSwitchIconS  = makeIcon("wallswitch-s.gif"),
                MultWallSwitchIconS = makeIcon("multwallswitch-s.gif"),
                FloorSwitchIconS = makeIcon("floorswitch-s.gif"),
                MultFloorSwitchIconS = makeIcon("multfloorswitch-s.gif"),
                SconceIconS      = makeIcon("sconce-s.gif"),
                DecorationIconS  = makeIcon("decoration-s.gif"),
                FDecorationIconS = makeIcon("fdecoration-s.gif"),
                PillarIconS      = makeIcon("pillar-s.gif"),
                InvisibleWallIconS = makeIcon("invisiblewall-s.gif"),
                EventIconS       = makeIcon("event-s.gif"),
                GameWinIconS     = makeIcon("gamewin-s.gif"),
                StormIconS       = makeIcon("stormbringer-s.gif"),
                GemIconS         = makeIcon("powergem-s.gif"),
                FulYaIconS       = makeIcon("fulya-s.gif");
        
        public static final boolean showDirIndicators = true;
        
        private DMEditor dmed;
        private ArrayList targets;
        private boolean needupdate = true;
        private Dimension bigdim,smalldim;
        private Font bigfont,smallfont;
        private Stroke normalstroke,arrowstroke;
        private Color floorcolor;
        private Graphics2D g;//,offg;
        private BufferedImage pic;
        //private Image offimage;

        public MapPanel(DMEditor dmed) {
                super(false);
                this.dmed = dmed;
                targets = new ArrayList(1);
                bigdim = new Dimension(dmed.MAPWIDTH*33,dmed.MAPHEIGHT*33);
                smalldim = new Dimension(dmed.MAPWIDTH*17,dmed.MAPHEIGHT*17);
                arrowstroke = new BasicStroke(2.0f);
                floorcolor = new Color(40,30,30);
                setBackground(floorcolor);
                setPreferredSize(bigdim);
                setMaximumSize(bigdim);
                bigfont = dmed.dungfont.deriveFont(8.0f);
                smallfont = dmed.dungfont.deriveFont(6.0f);
                pic = new BufferedImage(50*33,50*33,BufferedImage.TYPE_INT_BGR);
                g = pic.createGraphics();
                normalstroke = g.getStroke();
        }
        
        public void setNewSize() {
                if (dmed.MAPWIDTH!=(int)bigdim.getWidth()/33 || dmed.MAPHEIGHT!=(int)bigdim.getHeight()/33) {
                        bigdim = new Dimension(dmed.MAPWIDTH*33,dmed.MAPHEIGHT*33);
                        smalldim = new Dimension(dmed.MAPWIDTH*17,dmed.MAPHEIGHT*17);
                        if (dmed.MAPWIDTH>pic.getWidth(null)/33 || dmed.MAPHEIGHT>pic.getHeight(null)/33) {
                                pic.flush();
                                g.dispose();
                                pic = null;
                                System.gc();
                                pic = new BufferedImage(dmed.MAPWIDTH*33,dmed.MAPHEIGHT*33,BufferedImage.TYPE_INT_BGR);
                                g = pic.createGraphics();
                                normalstroke = g.getStroke();
                        }
                        setZoom();
                        g.setClip(0,0,dmed.MAPWIDTH*33,dmed.MAPHEIGHT*33);
                }
        }
        
        public void setZoom() {
                if (!dmed.ZOOMING) {
                        setPreferredSize(bigdim);
                        setMaximumSize(bigdim);
                        g.setFont(bigfont);
                }
                else {
                        g.setColor(floorcolor);
                        g.fillRect(0,0,dmed.MAPWIDTH*33,dmed.MAPHEIGHT*33);
                        setPreferredSize(smalldim);
                        setMaximumSize(smalldim);
                        g.setFont(smallfont);
                }
        }
        
        public void forcePaint() {
                super.repaint();
        }
        
        public void repaint() {
                needupdate = true;
                super.repaint();
        }
        
        private static void setAntiAliasing (Graphics2D gg, boolean on) {
               gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                                   on ? RenderingHints.VALUE_ANTIALIAS_ON
                                      : RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        
        // currently only for big icons:
        private void drawDirIndicator (Graphics2D gg, int xpos, int ypos, int side) {
                gg.setColor (Color.yellow);
                if (!dmed.ZOOMING) {
                        switch (side) {
                                case 0 : gg.fillRect (xpos+14, ypos+31, 4, 1);
                                        gg.fillRect (xpos+15, ypos+30, 2, 1);  break;
                                case 1 : gg.fillRect (xpos+31, ypos+14, 1, 4);
                                        gg.fillRect (xpos+30, ypos+15, 1, 2);  break;
                                case 2 : gg.fillRect (xpos+14, ypos,    4, 1);
                                        gg.fillRect (xpos+15, ypos+1,  2, 1);  break;
                                case 3 : gg.fillRect (xpos,    ypos+14, 1, 4);
                                        gg.fillRect (xpos+1,  ypos+15, 1, 2);  break;
                        }
                }
                else {
                        switch (side) {
                                case 0 : gg.fillRect (xpos+6, ypos+15, 4, 1);
                                        gg.fillRect (xpos+7, ypos+14, 2, 1);  break;
                                case 1 : gg.fillRect (xpos+15, ypos+6, 1, 4);
                                        gg.fillRect (xpos+14, ypos+7, 1, 2);  break;
                                case 2 : gg.fillRect (xpos+6, ypos,    4, 1);
                                        gg.fillRect (xpos+7, ypos+1,  2, 1);  break;
                                case 3 : gg.fillRect (xpos,    ypos+6, 1, 4);
                                        gg.fillRect (xpos+1,  ypos+7, 1, 2);  break;
                        }
                }
        }
        
        private void drawFieldAt (Graphics2D gg, int xpos, int ypos, MapData mapfield, boolean zoomed) {
                if (zoomed) {
                        Image mappic = getPic(mapfield);
                        if (mappic!=null) gg.drawImage(mappic,xpos,ypos,this);
                        /*
                           if (mappic!=null) {
                                java.awt.geom.AffineTransform t = null;
                                int side = 0;
                                if (mapfield.mapchar=='d') side = ((DoorData)mapfield).side;
                                else if (mapfield instanceof SidedWallData) side = ((SidedWallData)mapfield).side;
                                if (side!=0) {
                                        t = g.getTransform();
                                        g.setTransform(java.awt.geom.AffineTransform.getRotateInstance(-Math.PI/2.0*side,xpos+16,ypos+16));
                                }
                                g.drawImage(mappic,xpos,ypos,this);
                                if (t!=null) g.setTransform(t);
                           }
                        */
                        //nomons
                        if (mapfield.nomons) {
                                gg.setColor(Color.blue);
                                gg.drawRect(xpos,ypos,31,31);
                        }
                        //noghosts
                        else if (mapfield.noghosts) {
                                gg.setColor(Color.green);
                                gg.drawRect(xpos,ypos,31,31);
                        }
                        //items
                        gg.setColor(new Color(0,100,255));//Color.blue);
                        if (mapfield.hasItems && mapfield.mapchar!=']' && mapfield.mapchar!='[' && mapfield.mapchar!='a' && mapfield.mapchar!='f') { //not alcoves or fountain
                                if (mapfield.numitemsin[0]>0) gg.drawString("*",xpos+4,ypos+11);
                                if (mapfield.numitemsin[1]>0) gg.drawString("*",xpos+25,ypos+11);
                                if (mapfield.numitemsin[2]>0) gg.drawString("*",xpos+25,ypos+29);
                                if (mapfield.numitemsin[3]>0) gg.drawString("*",xpos+4,ypos+29);
                        }
                        else { //alcoves
                                if (mapfield.numitemsin[0]>0) gg.drawString("*",xpos+14,ypos+12);
                                if (mapfield.numitemsin[1]>0) gg.drawString("*",xpos+4,ypos+20);
                                if (mapfield.numitemsin[2]>0) gg.drawString("*",xpos+14,ypos+29);
                                if (mapfield.numitemsin[3]>0) gg.drawString("*",xpos+24,ypos+20);
                        }
                        //mons
                        if (mapfield.hasMons) {
                                gg.setColor(Color.red);
                                if (mapfield.hasmonin[0]) gg.drawString("*",xpos+7,ypos+14);
                                if (mapfield.hasmonin[1]) gg.drawString("*",xpos+22,ypos+14);
                                if (mapfield.hasmonin[2]) gg.drawString("*",xpos+22,ypos+26);
                                if (mapfield.hasmonin[3]) gg.drawString("*",xpos+7,ypos+26);
                                if (mapfield.hasmonin[4]) gg.drawString("*",xpos+14,ypos+20);
                        }
                        // direction indicator
                        if (mappic != null && showDirIndicators) {
                                if (mapfield.mapchar=='d') {
                                        int side = ((DoorData)mapfield).side;
                                        drawDirIndicator (gg, xpos, ypos, side);
                                        // also on the opposite side
                                        drawDirIndicator (gg, xpos, ypos, (side+2) & 3);
                                }
                                else if (mapfield instanceof SidedWallData) {
                                        int side = ((SidedWallData)mapfield).side;
                                        drawDirIndicator (gg, xpos, ypos, side);
                                }
                        }
                        //party
                        if (mapfield.hasParty) {
                                setAntiAliasing (gg, true);
                                gg.setColor(Color.green);
                                gg.drawArc(xpos+2,ypos+2,28,28,45,90);
                                gg.setColor(Color.yellow);
                                gg.drawArc(xpos+2,ypos+2,28,28,135,90);
                                gg.setColor(Color.red);
                                gg.drawArc(xpos+2,ypos+2,28,28,225,90);
                                gg.setColor(Color.blue);
                                gg.drawArc(xpos+2,ypos+2,28,28,315,90);
                                setAntiAliasing (gg, false);
                        }
                }
                else {
                        Image mappic = getPic(mapfield);
                        if (mappic!=null) gg.drawImage(mappic,xpos,ypos,this);
                        /*
                           if (mappic!=null) {
                                java.awt.geom.AffineTransform t = null;
                                int side = 0;
                                if (mapfield.mapchar=='d') side = ((DoorData)mapfield).side;
                                else if (mapfield instanceof SidedWallData) side = ((SidedWallData)mapfield).side;
                                if (side!=0) {
                                        t = g.getTransform();
                                        g.setTransform(java.awt.geom.AffineTransform.getRotateInstance(-Math.PI/2.0*side,xpos+8,ypos+8));
                                }
                                g.drawImage(mappic,xpos,ypos,this);
                                if (t!=null) g.setTransform(t);
                           }
                        */
                        //nomons
                        if (mapfield.nomons) {
                                gg.setColor(Color.blue);
                                gg.drawRect(xpos,ypos,15,15);
                        }
                        //noghosts
                        else if (mapfield.noghosts) {
                                gg.setColor(Color.green);
                                gg.drawRect(xpos,ypos,15,15);
                        }
                        //items
                        gg.setColor(new Color(0,100,255));//Color.blue);
                        if (mapfield.hasItems && mapfield.mapchar!=']' && mapfield.mapchar!='[' && mapfield.mapchar!='a' && mapfield.mapchar!='f') { //not alcoves or fountain
                                if (mapfield.numitemsin[0]>0) gg.drawString("*",xpos+2,ypos+6);
                                if (mapfield.numitemsin[1]>0) gg.drawString("*",xpos+12,ypos+6);
                                if (mapfield.numitemsin[2]>0) gg.drawString("*",xpos+12,ypos+16);
                                if (mapfield.numitemsin[3]>0) gg.drawString("*",xpos+2,ypos+16);
                        }
                        else { //alcoves
                                if (mapfield.numitemsin[0]>0) gg.drawString("*",xpos+7,ypos+6);
                                if (mapfield.numitemsin[1]>0) gg.drawString("*",xpos+2,ypos+11);
                                if (mapfield.numitemsin[2]>0) gg.drawString("*",xpos+7,ypos+16);
                                if (mapfield.numitemsin[3]>0) gg.drawString("*",xpos+12,ypos+11);
                        }
                        //mons
                        if (mapfield.hasMons) {
                                gg.setColor(Color.red);
                                if (mapfield.hasmonin[0]) gg.drawString("*",xpos+4,ypos+8);
                                if (mapfield.hasmonin[1]) gg.drawString("*",xpos+10,ypos+8);
                                if (mapfield.hasmonin[2]) gg.drawString("*",xpos+10,ypos+14);
                                if (mapfield.hasmonin[3]) gg.drawString("*",xpos+4,ypos+14);
                                if (mapfield.hasmonin[4]) gg.drawString("*",xpos+7,ypos+11);
                        }
                        // direction indicator
                        if (mappic != null && showDirIndicators) {
                                if (mapfield.mapchar=='d') {
                                        int side = ((DoorData)mapfield).side;
                                        drawDirIndicator (gg, xpos, ypos, side);
                                        // also on the opposite side
                                        drawDirIndicator (gg, xpos, ypos, (side+2) & 3);
                                }
                                else if (mapfield instanceof SidedWallData) {
                                        int side = ((SidedWallData)mapfield).side;
                                        drawDirIndicator (gg, xpos, ypos, side);
                                }
                        }
                        //party
                        if (mapfield.hasParty) {
                                setAntiAliasing (gg, true);
                                gg.setColor(Color.green);
                                gg.drawArc(xpos+1,ypos+1,14,14,45,90);
                                gg.setColor(Color.yellow);
                                gg.drawArc(xpos+1,ypos+1,14,14,135,90);
                                gg.setColor(Color.red);
                                gg.drawArc(xpos+1,ypos+1,14,14,225,90);
                                gg.setColor(Color.blue);
                                gg.drawArc(xpos+1,ypos+1,14,14,315,90);
                                setAntiAliasing (gg, false);
                        }
                }
        }
        
        public void paintSquare(int x, int y, boolean drawpic) {
                if (!dmed.ZOOMING) {
                        g.setColor(floorcolor);
                        g.fillRect(x*33,y*33,32,32);
                        drawFieldAt (g, x*33, y*33, dmed.mapdata[x][y], true);
                }
                else {
                        g.setColor(floorcolor);
                        g.fillRect(x*17,y*17,16,16);
                        drawFieldAt (g, x*17, y*17, dmed.mapdata[x][y], false);
                }
                if (drawpic) { 
                        //super.repaint();
                        paint(getGraphics());
                }
        }
        
        private void drawFieldLock (Graphics2D gg) {
                if (dmed.SQUARELOCKED) {
                        int size = (dmed.ZOOMING) ? 16 : 32;
                        gg.setColor(Color.white);
                        setAntiAliasing (gg, true);
                        gg.drawOval((int)(dmed.lockx*(size+1)-3*size/8),(int)(dmed.locky*(size+1)-3*size/8),(int)(size*1.75),(int)(size*1.75));
                        setAntiAliasing (gg, false);
                }
        }
        
        public void paint(Graphics ong) {
                Graphics2D gg = (Graphics2D)ong;
                if (!needupdate) { 
                        gg.drawImage(pic,0,0,this);
                        if (!targets.isEmpty()) drawTargets(gg);
                        drawFieldLock (gg);
                        return;
                }
                if (!dmed.ZOOMING) {
                   g.setColor(floorcolor);
                   g.fillRect(0,0,dmed.MAPWIDTH*33,dmed.MAPHEIGHT*33);
                   g.setFont(bigfont);
                   for (int y=0;y<dmed.MAPHEIGHT;y++) {
                       for (int x=0;x<dmed.MAPWIDTH;x++) {
                           drawFieldAt (g, x*33, y*33, dmed.mapdata[x][y], true);
                       }
                   }
                }
                else { //ZOOMING
                   g.setColor(floorcolor);
                   g.fillRect(0,0,dmed.MAPWIDTH*17,dmed.MAPHEIGHT*17);
                   g.setFont(smallfont);
                   for (int y=0;y<dmed.MAPHEIGHT;y++) {
                       for (int x=0;x<dmed.MAPWIDTH;x++) {
                           drawFieldAt (g, x*17, y*17, dmed.mapdata[x][y], false);
                       }
                   }
                }
                needupdate = false;
                gg.drawImage(pic,0,0,this);
                if (!targets.isEmpty()) drawTargets(gg);
                drawFieldLock (gg);
        }
        
        private void drawTargets (Graphics2D gg) {
                // iterate thru targets arraylist, drawing red borders
                // (and maybe actual arrows and up/down level indicators)
                int size = (dmed.ZOOMING) ? 16 : 32;
                gg.setColor(Color.red);
                Target target;
                int numtargets = targets.size();
                for (int i=0;i<numtargets;i++) {
                        target = (Target)targets.get(i);
                        if (target.targetl==dmed.currentlevel) {
                                gg.drawRect(target.targetx*(size+1),target.targety*(size+1),size-1,size-1);
                        }
                }
                if (!dmed.ZOOMING) gg.setStroke(arrowstroke);
                for (int i=0;i<numtargets;i++) {
                        target = (Target)targets.get(i);
                        if (target.targetl==dmed.currentlevel) {
                                gg.drawLine(target.originx*(size+1)+size/2,target.originy*(size+1)+size/2,target.targetx*(size+1)+size/2,target.targety*(size+1)+size/2);
                        }
                        else {
                                setAntiAliasing (gg, true);
                                gg.drawOval((int)(target.originx*(size+1)-size/4),(int)(target.originy*(size+1)-size/4),(int)(size*1.5),(int)(size*1.5));
                                setAntiAliasing (gg, false);
                        }
                }
                if (!dmed.ZOOMING) gg.setStroke(normalstroke);
        }
        
        private Image getPic(MapData m) {
                if (m.mapchar=='1') { if (!dmed.ZOOMING) return WallIcon.getImage(); else return WallIconS.getImage(); }
                else if (m.mapchar=='0') return null;
                else if (m.mapchar=='2') { if (!dmed.ZOOMING) return FakeWallIcon.getImage(); else return FakeWallIconS.getImage(); }
                else if (m.mapchar=='>') {
                        if (!dmed.ZOOMING) {
                                if (((StairsData)m).goesUp) return StairsUpIcon.getImage();
                                else return StairsDownIcon.getImage();
                        }
                        else {
                                if (((StairsData)m).goesUp) return StairsUpIconS.getImage();
                                else return StairsDownIconS.getImage();
                        }
                }
                else if (m.mapchar=='d') { if (!dmed.ZOOMING) return DoorIcon.getImage(); else return DoorIconS.getImage(); }
                else if (m.mapchar=='s') { if (!dmed.ZOOMING) return FloorSwitchIcon.getImage(); else return FloorSwitchIconS.getImage(); }
                else if (m.mapchar=='/') { if (!dmed.ZOOMING) return WallSwitchIcon.getImage(); else return WallSwitchIconS.getImage(); }
                else if (m.mapchar=='t') { if (!dmed.ZOOMING) return TeleportIcon.getImage(); else return TeleportIconS.getImage(); }
                else if (m.mapchar==']' || m.mapchar=='[') { if (!dmed.ZOOMING) return AlcoveIcon.getImage(); else return AlcoveIconS.getImage(); }
                else if (m.mapchar=='a') { if (!dmed.ZOOMING) return AltarIcon.getImage(); else return AltarIconS.getImage(); }
                else if (m.mapchar=='f') { if (!dmed.ZOOMING) return FountainIcon.getImage(); else return FountainIconS.getImage(); }
                else if (m.mapchar=='p') { if (!dmed.ZOOMING) return PitIcon.getImage(); else return PitIconS.getImage(); }
                else if (m.mapchar=='l') { if (!dmed.ZOOMING) return LauncherIcon.getImage(); else return LauncherIconS.getImage(); }
                else if (m.mapchar=='m') { if (!dmed.ZOOMING) return MirrorIcon.getImage(); else return MirrorIconS.getImage(); }
                else if (m.mapchar=='g') { if (!dmed.ZOOMING) return GeneratorIcon.getImage(); else return GeneratorIconS.getImage(); }
                else if (m.mapchar=='w') { if (!dmed.ZOOMING) return WritingIcon.getImage(); else return WritingIconS.getImage(); }
                else if (m.mapchar=='S') { if (!dmed.ZOOMING) return MultFloorSwitchIcon.getImage(); else return MultFloorSwitchIconS.getImage(); }
                else if (m.mapchar=='\\') { if (!dmed.ZOOMING) return MultWallSwitchIcon.getImage(); else return MultWallSwitchIconS.getImage(); }
                else if (m.mapchar=='}') { if (!dmed.ZOOMING) return SconceIcon.getImage(); else return SconceIconS.getImage(); }
                else if (m.mapchar=='D') { if (!dmed.ZOOMING) return DecorationIcon.getImage(); else return DecorationIconS.getImage(); }
                else if (m.mapchar=='F') { if (!dmed.ZOOMING) return FDecorationIcon.getImage(); else return FDecorationIconS.getImage(); }
                else if (m.mapchar=='P') { if (!dmed.ZOOMING) return PillarIcon.getImage(); else return PillarIconS.getImage(); }
                else if (m.mapchar=='i') { if (!dmed.ZOOMING) return InvisibleWallIcon.getImage(); else return InvisibleWallIconS.getImage(); }
                else if (m.mapchar=='E') { if (!dmed.ZOOMING) return EventIcon.getImage(); else return EventIconS.getImage(); }
                else if (m.mapchar=='!') { if (!dmed.ZOOMING) return StormIcon.getImage(); else return StormIconS.getImage(); }
                else if (m.mapchar=='G') { if (!dmed.ZOOMING) return GemIcon.getImage(); else return GemIconS.getImage(); }
                else if (m.mapchar=='y') { if (!dmed.ZOOMING) return FulYaIcon.getImage(); else return FulYaIconS.getImage(); }
                else if (m.mapchar=='W') { if (!dmed.ZOOMING) return GameWinIcon.getImage(); else return GameWinIconS.getImage(); }
                else return null;
        }
        
        public boolean clearTargets() {
                if (targets.isEmpty()) return false;
                targets.clear();
                return true;
        }
        
        public boolean doTargets(MapData md, int x, int y) {
                int oldsize = targets.size();
                if (md.mapchar=='t') {
                        targets.add(new Target(x,y,((TeleportData)md).targetlevel,((TeleportData)md).targetx,((TeleportData)md).targety));
                }
                else if (md.mapchar=='/') {
                        targets.add(new Target(x,y,((WallSwitchData)md).targetlevel,((WallSwitchData)md).targetx,((WallSwitchData)md).targety));
                }
                else if (md.mapchar=='s') {
                        targets.add(new Target(x,y,((FloorSwitchData)md).targetlevel,((FloorSwitchData)md).targetx,((FloorSwitchData)md).targety));
                }
                else if (md.mapchar=='\\') {
                        MultWallSwitchData mwd = (MultWallSwitchData)md;
                        int[] target;
                        for (int i=0;i<mwd.switchlist.size();i++) {
                                target = mwd.getTarget(i);
                                targets.add(new Target(x,y,target[0],target[1],target[2]));
                        }
                }
                else if (md.mapchar=='S') {
                        MultFloorSwitchData mwd = (MultFloorSwitchData)md;
                        int[] target;
                        for (int i=0;i<mwd.switchlist.size();i++) {
                                target = mwd.getTarget(i);
                                targets.add(new Target(x,y,target[0],target[1],target[2]));
                        }
                }
                else if (md.mapchar=='}') {
                        SconceData d = (SconceData)md;
                        if (d.isSwitch) {
                                int[] target;
                                for (int i=0;i<d.sconceswitch.switchlist.size();i++) {
                                        target = d.sconceswitch.getTarget(i);
                                        targets.add(new Target(x,y,target[0],target[1],target[2]));
                                }
                        }
                }
                else if (md instanceof OneAlcoveData) {
                        OneAlcoveData d = (OneAlcoveData)md;
                        if (d.isSwitch) {
                                int[] target;
                                for (int i=0;i<d.alcoveswitchdata.switchlist.size();i++) {
                                        target = d.alcoveswitchdata.getTarget(i);
                                        targets.add(new Target(x,y,target[0],target[1],target[2]));
                                }
                        }
                }
                else if (md.mapchar=='[') {
                        AlcoveData d = (AlcoveData)md;
                        if (d.isSwitch) {
                                int[] target;
                                for (int i=0;i<d.alcoveswitchdata.switchlist.size();i++) {
                                        target = d.alcoveswitchdata.getTarget(i);
                                        targets.add(new Target(x,y,target[0],target[1],target[2]));
                                }
                        }
                }
                else if (md.mapchar=='f') {
                        FountainData d = (FountainData)md;
                        if (d.fountainswitch!=null) {
                                int[] target;
                                for (int i=0;i<d.fountainswitch.switchlist.size();i++) {
                                        target = d.fountainswitch.getTarget(i);
                                        targets.add(new Target(x,y,target[0],target[1],target[2]));
                                }
                        }
                }
                else if (md.mapchar=='E') {
                        EventSquareData ed = (EventSquareData)md;
                        Action a;
                        for (int i=0;i<ed.choices.length;i++) {
                                for (int j=0;j<ed.choices[i].actions.size();j++) {
                                        a = (Action)ed.choices[i].actions.get(j);
                                        if (a.actiontype>0 && a.actiontype<4) {
                                                targets.add(new Target(x,y,((MapPoint)a.action).level,((MapPoint)a.action).x,((MapPoint)a.action).y));
                                        }
                                }
                        }
                        
                }
                else if (md.mapchar=='m') {
                        if (((MirrorData)md).target!=null) targets.add(new Target(x,y,((MirrorData)md).target.level,((MirrorData)md).target.x,((MirrorData)md).target.y));
                }
                else if (md.mapchar=='y') {
                        FulYaPitData fypit = (FulYaPitData)md;
                        targets.add(new Target(x,y,fypit.keytarget.level,fypit.keytarget.x,fypit.keytarget.y));
                        targets.add(new Target(x,y,fypit.nonkeytarget.level,fypit.nonkeytarget.x,fypit.nonkeytarget.y));
                }
                if (targets.size()!=oldsize) return true;
                else return false;
        }
        
        private class Target {
                int originx,originy;
                int targetl,targetx,targety;
                
                public Target(int ox,int oy,int tl,int tx,int ty) {
                        originx = ox;
                        originy = oy;
                        targetl = tl;
                        targetx = tx;
                        targety = ty;
                }
        }
}
